package com.reyun.repository;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import com.reyun.model.Event;

@Transactional
public interface EventRepository extends JpaRepository<Event, Long> {

    List<Event> findByAppkey(String appkey);

    @Query(value = "select * from event_source where appkey = ?1 and event_name in ?2 ", nativeQuery = true)
    List<Event> findByAppkeyAndNames(String appKey,List<String> names);

    @Query(value = "select * from event_source where appkey = ?1 group by event_name ", nativeQuery = true)
    List<Event> findAllEventByAppKey(String appKey);

    @Query(value = "select * from event_source where appkey = ?1 and event_attr = ?2 limit 1", nativeQuery = true)
    Event findOneEventByAttr(String appKey, String eventAttr);

    @Query(value = "select * from event_source where appkey = ?1 and event_attr = ?2 and event_name = ?3", nativeQuery = true)
    Event findNumberAttrByEventAttr(String appKey,String attrName,String eventName);

    @Query(value = "select * from event_source where appkey = ?1 and event_name = ?2", nativeQuery = true)
    List<Event> findByEventName(String appkey, String name);

    @Query(value = "select * from event_source where appkey = ?1 and common = true", nativeQuery = true)
    List<Event> listCommonByApp(String appkey);

    @Query(value = "select * from event_source where appkey = ?1 and event_name in (?2)", nativeQuery = true)
    List<Event> findEventAliasByEvent(String appkey, List<String> eventNames);

    @Query(value = "select * from event_source where appkey = ?1 and data_type = ?2 ", nativeQuery = true)
    List<Event> findAllAttrByDataType(String appKey, String dataType);

    @Query(value = "select * from event_source where appkey = ?3 and event_attr = ?1 and event_name = ?2", nativeQuery = true)
    List<Event> findByAttr(String attr, String eventName, String appKey);

    @Query(value = "select * from event_source where appkey = ?3 and event_attr = ?1 and event_name in (?2)", nativeQuery = true)
    List<Event> findByEventsAndAttr(List<String> events, String attr, String appKey);

    @Transactional
    @Modifying
    @Query(value = "update event_source set add_stats_view  = ?4 , modify_account = ?5, modify_time = ?6 where appkey = ?1 and event_name = ?2 and event_attr = ?3  and data_type = 'number' ", nativeQuery = true)
    int updateEventStatsAttr(String appKey, String eventName, String attrName, Boolean statsFlag, Long account, Date date);

    @Transactional
    @Modifying
    @Query(value = "update event_source set add_stats_condition  = ?4 , modify_account = ?5, modify_time = ?6 where appkey = ?1 and event_name = ?2 and event_attr = ?3 ", nativeQuery = true)
    int updateEventStatsCondition(String appKey, String eventName, String attrName, Boolean statsFlag, Long account, Date date);
}
