package com.reyun.repository;

import com.reyun.model.IONotice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by sunhao on 17/3/1.
 */
@Transactional
public interface NoticeRepository  extends JpaRepository<IONotice, Long> {

//    @Query(value = "select * from ionotice n where n.isdeploy is true and  (io_account like %?1% or io_account = '-1') order by deploy_date desc", nativeQuery = true)
//    List<IONotice> listRecentDeployNotice(String email);

    @Query(value = "select * from ionotice n where n.isdeploy is true and n.deploy_date>= ?1 and (io_account='-1' or io_account like CONCAT('%<',?2,'>%')) union select * from ionotice where is_top=1 and isdeploy is true and deploy_date< ?1 and (io_account='-1' or io_account like CONCAT('%<',?2,'>%')) order by deploy_date desc"
            , nativeQuery = true)
    List<IONotice> listRecentDeployNotice(String currentDate, Long rootParent);


}
