package com.reyun.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import com.reyun.model.UserGroup;

public interface UserGroupRepository extends JpaRepository<UserGroup, Long> {
	
	@Query(value="select * from usergroup where account = ?1",nativeQuery=true)
	List<UserGroup> listByAccount(Long createAccount);
	
	@Query(value="select * from user_group where app = ?1 and account = ?2 and del_flag is not true",nativeQuery=true)
	List<UserGroup> listByApp(Long app,Long account);
	
	@Query(value="select * from user_group where app = ?1 and del_flag is not true",nativeQuery=true)
	List<UserGroup> listByApp(Long app);
	
	UserGroup findByName(String name);
	
	@Query(value="select * from user_group where app = ?1 and account = ?2 and name = ?3 and del_flag is not true",nativeQuery=true)
	UserGroup findByName(Long app,Long account,String name);
	
}
