package com.reyun.repository;

import com.reyun.model.UserLog;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.math.BigInteger;
import java.util.List;


public interface UserLogRepository extends JpaRepository<UserLog, Long> {

	@Query(value = "select * from audit a where a.master_login is not true and a.email like %?1% and a.type=?2 and a.ds>=?3 and a.ds<=?4 order by a.pub_date desc limit ?5, ?6", nativeQuery = true)
	List<UserLog> findAllByEmailAndType(String email, String type,
			String startDate, String endDate, int start, int end);

	@Query(value = "select * from audit a where a.master_login is not true and a.email like %?1% and a.ds>=?2 and a.ds<=?3 order by a.pub_date desc limit ?4, ?5", nativeQuery = true)
	List<UserLog> findAllByEmail(String email, String startDate, String endDate,
			int start, int end);

	@Query(value = "select * from audit a where a.master_login is not true and a.type=?1 and a.ds>=?2 and a.ds<=?3 order by a.pub_date desc limit ?4, ?5", nativeQuery = true)
	List<UserLog> findAllByType(String type, String startDate, String endDate,
			int start, int end);

	@Query(value = "select * from audit a where a.master_login is not true and a.ds>=?1 and a.ds<=?2 order by a.pub_date desc limit ?3, ?4", nativeQuery = true)
	List<UserLog> findAll(String startDate, String endDate, int start, int end);
	
	@Query(value = "select count(*) from audit a where a.master_login is not true and a.email like %?1% and a.type=?2 and a.ds>=?3 and a.ds<=?4", nativeQuery = true)
	BigInteger getCount(String email, String type, String startDate, String endDate);
	
	@Query(value = "select count(*) from audit a where a.master_login is not true and a.email like %?1% and a.ds>=?2 and a.ds<=?3", nativeQuery = true)
	BigInteger getCountByEmail(String email, String startDate, String endDate);
	
	@Query(value = "select count(*) from audit a where a.master_login is not true and a.type=?1 and a.ds>=?2 and a.ds<=?3", nativeQuery = true)
	BigInteger getCountByType(String type, String startDate, String endDate);
	
	@Query(value = "select count(*) from audit a where a.master_login is not true and a.ds>=?1 and a.ds<=?2", nativeQuery = true)
	BigInteger getCount(String startDate, String endDate);

    @Query(value = "select * from user_log where master_login is not true and email = ?1 and type = 'login' order by pub_date desc limit 4", nativeQuery = true)
    List<UserLog> findRecentUserLog(String email);
}
