package com.reyun.service;

import com.reyun.model.Account;
import com.reyun.model.EventStats;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * Created by sunhao on 17/9/21.
 * 复杂事件service
 */
public interface ComplicateEventsService {

    boolean checkEventStatsName(Long accountId, String eventStatsName, Long appId);

    EventStats createEventStats(EventStats eventStats);

    int updateEventStats(EventStats eventStats, Long accountId);

    int deleteEventStats(Long eventStatsId, Long accountId);

    List<EventStats> findAllEventStats(Long accountId, Long appId);

    Map<String, List> queryComplicatedEvent(Long appId, Long accountId, String startDate, String endDate, String eventCondition, String viewType);

    List<JSONObject> queryDistinctTotalData(Long appId, Long accountId, String startDate, String endDate, String eventCondition, String viewType);

    boolean importOldEventData(Account account);

    boolean checkImportComplicated(Account account);
}
