package com.reyun.service;

import com.reyun.model.*;
import org.json.JSONException;

import java.util.List;
import java.util.Map;


public interface EventService {

    List<Event4Web> listEvent(Long app);

    List<EventAttr4Web> listOneEvent(Long app, String name);

    Map<String, String> findEventNameAliasMap(String appKey, List<String> eventName);

    EventMeta updateEvent(Long app, String name, String nameAlias, Long account);

    EventAttributeMeta updateEventAttr(String eventName, String attrNameAlias, Long account, Long app);

    void enableEvent(Long app, String name, Long account);

    void forbiddenEvent(Long app, String name, Long account);

    EventAttributeMeta enableAttr(Long app, String name, Long account);

    EventAttributeMeta forbiddenAttr(Long app, String name, Long account);

    EventAttributeMeta updateEventStatsView(Long appId, Long account, String attrName, Boolean addFlag);

    EventAttributeMeta updateEventStatsCondition(Long appId, Long account, String attrName, Boolean addFlag);

//    List<Event4Web> listAll(Long app);
//


    Map<String, List<String>> findAllEventWithAttr(Long appId);

    List<Event4Web> listAllEvent(Long app);

    List<Event4Web> listAllEventToCallback(Long app);

    List<Event4Web> listAllNew(Long app, String names,String params) throws JSONException;

    Map<String,List> listAllValue(Long app, String eventName, String attrName);

    Map<String, List> listAllValueByAttr(Long app, String attrName);

    Map<String, Map<String, List>> listAllValueByAttrs(Long app, String attrNames);

    List<Dimension4Web> listValues(Long app);

    List<EventAttr4Web> listCommonProperties(Long app, String propertiesType);

    List<CommonParam> listCommonGroupProperties();

    List<EventAttr4Web> listAllEventAttribute(String event, Long appId);

    List<ComplicatedParam> findAllComplicatedPatram();

    List<CommonParam> listAllAttributes(Long appId);

    List<Profile> listByAppkeyBugFix(Long appId);

    Map<String, List> listAllValueByAttrTop50(Long appId, String attrName);

    List<EventAttr4Web> listAllEventAttributesTop50(Long appId,String propertiesType);


    List<Dimension4Web> listAllAttr(Long app);

    List<Event4Tracking> listEvent4Tracking(Long app);

}
