package com.reyun.service;

import java.util.List;
import java.util.Map;

import com.reyun.model.Account;
import com.reyun.model.Retention;


public interface RetentionService {
	
	Retention create(Retention retention, Long account);
	
	Retention update(Retention retention, Long account);
	
	Retention delete(Long id, Long account);
	
	Retention findById(Long id);
	
	List<Retention> findByApp(Long app);
	
	Retention validName(String name, Long app);
	
	Map<String, List> retentionReport(String startDate, String endDate, boolean isList, String eventInfo, Long app, String usergroup, String dimention, String reportView, int interval, boolean isDevice, Long account,String retentiontype,boolean isProfile);
	
	Map<String, List> retentionDetailReport(Account account, String startDate, String endDate, boolean isList, String eventInfo, Long app, String usergroup, String dimention, String reportView, int interval, boolean isDevice, String retentiontype, boolean isProfile);
	
}
