package com.reyun.service.impl;

import com.reyun.model.DemoAppointment;
import com.reyun.repository.DemoAppointmentRepository;
import com.reyun.service.DemoAppointmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigInteger;

/**
 * Created by nolan on 06/06/2017.
 * description:
 */
@Service
public class DemoAppointmentServiceImpl implements DemoAppointmentService {
	private static Logger logger = LoggerFactory.getLogger(DemoAppointmentServiceImpl.class);

	@Autowired
	private DemoAppointmentRepository demoAppointmentRepository;

	@Override
	public DemoAppointment freetrial(DemoAppointment demoAppointment) {
		//1. 申请
		demoAppointment = demoAppointmentRepository.save(demoAppointment);
		logger.debug("创建预约申请, {}", demoAppointment);
		return demoAppointment;
	}

	@Override
	public boolean checkExist(String phone) {
		BigInteger bigInteger = demoAppointmentRepository.countByPhone(phone);
		return bigInteger.intValue() > 0;
	}
}
