package com.reyun.service.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.reyun.model.Account;
import com.reyun.model.IONotice;
import com.reyun.model.UserNoticeLog;
import com.reyun.repository.AccountRepository;
import com.reyun.repository.NoticeRepository;
import com.reyun.repository.UserNoticeLogRepository;
import com.reyun.service.NoticeService;
import com.reyun.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by sunhao on 17/3/1.
 */
@Service
public class NoticeServiceImpl implements NoticeService {

    @Autowired
    private NoticeRepository noticeRepository;

    @Autowired
    private UserNoticeLogRepository userNoticeLogRepository;

    @Autowired
    private AccountRepository accountRepository;

    @Override
    public List<IONotice> listRecentDeployNotice(Long accountId) {

        Account account = accountRepository.findOne(accountId);

        List<IONotice> recentDeployNoticeList = noticeRepository.listRecentDeployNotice(DateUtil.getBeforeDays(7), account.getRootParent());
        List<IONotice> result = new ArrayList<>();

        if (!CollectionUtils.isEmpty(recentDeployNoticeList)) {

            List<Long> noticeIdList = Lists.transform(recentDeployNoticeList, new Function<IONotice, Long>() {
                @Override
                public Long apply(IONotice notice) {
                    return notice.getId();
                }
            });
            List<UserNoticeLog> userNoticeLogList = userNoticeLogRepository.listUserNoticeLog(accountId, noticeIdList);

            for (UserNoticeLog userNoticeLog : userNoticeLogList) {

                for (IONotice notice : recentDeployNoticeList) {

                    if (notice.getId().equals(userNoticeLog.getNoticeid())) {
                        notice.setIsRead(true);
                    }
                }
            }
            List<IONotice> unreadTopList = new ArrayList<>();
            List<IONotice> unreadNotTopList = new ArrayList<>();
            List<IONotice> readTopList = new ArrayList<>();
            List<IONotice> readNotTopList = new ArrayList<>();
            for (IONotice notice : recentDeployNoticeList) {
                boolean isread = notice.getIsRead()==null?false:notice.getIsRead();
                if (!isread && notice.getIs_top()) {
                    unreadTopList.add(notice);
                } else if (!isread && !notice.getIs_top()) {
                    unreadNotTopList.add(notice);
                } else if (isread && notice.getIs_top()) {
                    readTopList.add(notice);
                } else {
                    readNotTopList.add(notice);
                }
            }
            result.addAll(unreadTopList);
            result.addAll(unreadNotTopList);
            result.addAll(readTopList);
            result.addAll(readNotTopList);
        }

        return result;
    }

    @Override
    public UserNoticeLog saveReadLog(UserNoticeLog userNoticeLog) {

        UserNoticeLog resultUserNoticeLog = userNoticeLogRepository.findUserNoticeLog(userNoticeLog.getNoticeid(), userNoticeLog.getAccountid());

        if (null == resultUserNoticeLog) {
            resultUserNoticeLog = userNoticeLogRepository.saveAndFlush(userNoticeLog);
        }

        return resultUserNoticeLog;
    }
}
