package com.reyun.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.reyun.model.CommonParam;
import com.reyun.repository.CommonParamRepository;
import com.reyun.service.EventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.reyun.model.Profile;
import com.reyun.repository.AppRepository;
import com.reyun.repository.ProfileRepository;
import com.reyun.service.ProfileService;
import com.reyun.util.ValidateUtil;

import javax.annotation.Nullable;

@Service
public class ProfileServiceImpl
        implements ProfileService
{

    @Autowired
    ProfileRepository profileRepository;

    @Autowired
    AppRepository appRepository;

    @Autowired
    CommonParamRepository commonParamRepository;

    @Autowired
    EventService eventService;

    @Override
    public List<Profile> listAllByAppkey(Long appid)
    {
        String appkey = this.appRepository.findAppkeyById(appid);
        List<Profile> oldResult = this.profileRepository.findByAppkey(appkey);
        List<Profile> newResult = new ArrayList<Profile>();
        for (Profile temp : oldResult) {
            //校验属性名不是中文
            if (ValidateUtil.validNotChinese(temp.getAttr())) {

                if (!ValidateUtil.isValid(temp.getAttrAlias())) {
                    temp.setAttrAlias(temp.getAttr());
                }
                newResult.add(temp);
            }
        }
        return newResult;
    }

    @Override
    public Profile update(Profile resource, Long accountid)
    {
        // id -1系统管理员
        Profile result = this.profileRepository.findAllByAppkeyAndAttr(resource.getAppkey(), resource.getAttr());
        result.setAttrAlias(resource.getAttrAlias());
        result.setModifyAccount(accountid);
        result.setModifyTime(new Date());

        return this.profileRepository.save(result);
    }

    @Override
    public Profile enable(String appkey, String attr,  Long accountid)
    {

        Profile profile = this.profileRepository.findAllByAppkeyAndAttr(appkey, attr);

        profile.setModifyAccount(accountid);
        profile.setModifyTime(new Date());
        profile.setStatus(true);

        return this.profileRepository.save(profile);
    }

    @Override
    public Profile forbidden(String appkey, String attr,  Long accountid)
    {

        Profile profile = this.profileRepository.findAllByAppkeyAndAttr(appkey, attr);

        profile.setModifyAccount(accountid);
        profile.setModifyTime(new Date());
        profile.setStatus(false);
        return this.profileRepository.save(profile);
    }

    @Override
    public int updateProfileStatsCondition(Long appId, String attr, boolean flag) {
        String appkey = appRepository.findAppkeyById(appId);
        return profileRepository.updateByAppkeyAndAttr(flag,appkey,attr);
    }

/*    @Override
    public List<Profile> listByAppkey(Long appid)
    {
        String appkey = this.appRepository.findAppkeyById(appid);
        List<Profile> oldResult = this.profileRepository.findAllByAppkey(appkey);
        List<CommonParam> profileCommonParams = this.commonParamRepository.findAllByType("profile");
        List<Profile> newResult = new ArrayList<Profile>();

        Profile profile = null;
        for (CommonParam commonParam : profileCommonParams) {
            profile = new Profile();
            profile.setAppkey(appkey);
            profile.setAttrAlias(commonParam.getAlias());
            profile.setAttr(commonParam.getParam());
            profile.setCommon(true);
            profile.setStatus(true);
            profile.setDataType(commonParam.getDataType());
            newResult.add(profile);
        }

        for (Profile temp : oldResult) {
            if (ValidateUtil.validNotChinese(temp.getAttr())) {
                if (!ValidateUtil.isValid(temp.getAttrAlias())) {
                    temp.setAttrAlias(temp.getAttr());
                }
                newResult.add(temp);
            }
        }
        return newResult;
    }*/

    @Override
    public List<Profile> listByAppkey(Long appid) {
/*        String appkey = appRepository.findAppkeyById(appid);
        List<Profile> oldResult = profileRepository.findAllByAppkey(appkey);
        List<CommonParam> profileCommonParams = commonParamRepository.findAllByType("profile");
        Map<String, CommonParam> profileCommonParamsMaps = Maps.uniqueIndex(profileCommonParams, new Function<CommonParam, String>() {
            @Nullable
            @Override
            public String apply(@Nullable CommonParam commonParam) {
                return commonParam.getParam();
            }
        });

        List<Profile> newResult = new ArrayList<Profile>();
        for (CommonParam commonParam : profileCommonParams) {
            Profile profile = new Profile();
            profile.setAppkey(appkey);
            profile.setAttrAlias(commonParam.getAlias());
            profile.setAttr(commonParam.getParam());
            profile.setCommon(true);
            profile.setStatus(true);
            profile.setDataType(commonParam.getDataType());
            newResult.add(profile);
        }

        for (Profile temp : oldResult) {
            if (!profileCommonParamsMaps.containsKey(temp.getAttr())) {
                if (ValidateUtil.validNotChinese(temp.getAttr())) {
                    if (!ValidateUtil.isValid(temp.getAttrAlias())) {
                        temp.setAttrAlias(temp.getAttr());
                    }
                    newResult.add(temp);
                }
            }
        }
        return newResult;*/
        return eventService.listByAppkeyBugFix(appid);
    }
}
