package com.reyun.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;
import java.util.List;
import java.util.ResourceBundle;

/**
 * 数据库工具类
 * @author ruijie liruijie0603@126.com
 * @date 2014-11-28
 */
public class DBUtil {
	private final static Logger logger = LoggerFactory.getLogger(DBUtil.class);
	
	private static DBUtil dbUtil;
	
	private String driverClass = "";
	private String url = "";
	private String username = "";
	private String password = "";

	private String prestoDriverClass = "";
	private String prestoUrl = "";
	private String prestoUsername = "";

	private String hiveDriverClass = "";
	private String hiveUrl = "";
	private String hiveUsername = "";
	
	private DBUtil() {
		driverClass = Constant.dbdriver;
		url = Constant.dburl;
		username = Constant.dbusername;
		password = Constant.dbpassword;
		prestoDriverClass = Constant.prestoDriverClass;
		prestoUrl = Constant.prestoUrl;
		prestoUsername = Constant.prestoUsername;
		hiveDriverClass = Constant.hiveDriverClass;
		hiveUrl = Constant.hiveUrl;
		hiveUsername = Constant.hiveUsername;
	}
	
	public static DBUtil newInstance() {
		if (dbUtil == null) {
			dbUtil = new DBUtil();
		}
		return dbUtil;
	}
	
	public Connection getConn() {
		Connection conn = null;
		try {
			Class.forName(driverClass);
			conn = DriverManager.getConnection(url, username, password);
		} catch (ClassNotFoundException e) {
			logger.error(e.getMessage(), e);
		} catch (SQLException e) {
			logger.error(e.getMessage(), e);
		}
		
		return conn;
	}

	public Connection getPrestoConn() {
		Connection conn = null;
		try {
			Class.forName(prestoDriverClass);
			conn = DriverManager.getConnection(prestoUrl, prestoUsername,
					"");
		} catch (ClassNotFoundException e) {
			logger.error(e.getMessage(), e);
		} catch (SQLException e) {
			logger.error(e.getMessage(), e);
		}

		return conn;
	}

	public Connection getHiveConn() {
		Connection conn = null;
		try {
			Class.forName(hiveDriverClass);
			conn = DriverManager.getConnection(hiveUrl, hiveUsername,
					"");
		} catch (ClassNotFoundException e) {
			logger.error(e.getMessage(), e);
		} catch (SQLException e) {
			logger.error(e.getMessage(), e);
		}

		return conn;
	}
	
	public void insert(String sql) {
		Connection conn = getConn();
		Statement statement = null;
		try {
			statement = conn.createStatement();
			statement.execute(sql);
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			try {
				if (statement != null)
					statement.close();
				if (conn != null)
					conn.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}
	
	public ResultSet query(String sql) {
		Connection conn = getConn();
		Statement statement = null;
		ResultSet rs = null;
		try {
			statement = conn.createStatement();
			rs = statement.executeQuery(sql);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return rs;
	}
	
	public PreparedStatement getStatement(Connection conn, String sql) {
		PreparedStatement pstmt = null;
		try {
			pstmt = conn.prepareStatement(sql);
		} catch (SQLException e) {
			logger.error(e.getMessage(), e);
		}
		return pstmt;
	}
	
	public void release(ResultSet rs, PreparedStatement pstmt, Connection conn) {
		try {
			if (rs != null) {
				rs.close();
				rs = null;
			}
		} catch (SQLException e) {
			logger.error(e.getMessage(), e);
		} finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (SQLException e) {
				logger.error(e.getMessage(), e);
			} finally {
				try {
					if (conn != null) {
						conn.close();
						conn = null;
					}
				} catch (SQLException e) {
					logger.error(e.getMessage(), e);
				}
			}
		}
	}
	
	
	public static void release(ResultSet rs,Statement pstmt, Connection conn) {
		try {
			if (rs != null) {
				rs.close();
				rs = null;
			}
		} catch (SQLException e) {
			logger.error(e.getMessage(), e);
		} finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (SQLException e) {
				logger.error(e.getMessage(), e);
			} finally {
				try {
					if (conn != null) {
						conn.close();
						conn = null;
					}
				} catch (SQLException e) {
					logger.error(e.getMessage(), e);
				}
			}
		}
	}
	
	public void ExcuteNonQueryBatch(List<String> sqlList) {
		Connection conn = null;
		Statement _Statement = null;
		try {

			if (sqlList != null && sqlList.size() > 0) {
				conn = getConn();
				conn.setAutoCommit(false);
				for (int i = 0; i < sqlList.size(); i++) {
					_Statement = conn.createStatement();
					
					logger.info(sqlList.get(i));
					_Statement.executeUpdate(sqlList.get(i));
					// System.out.println(sqlList.get(i));
				}
				conn.commit();
			}

		} catch (Exception e) {

			try {
				if (_Statement != null)
					_Statement.close();
				if (conn != null)
					conn.close();
			} catch (SQLException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		}
	}
}
