(function(){
    angular.module("app.collect")
        .controller("reportCtrl",["$rootScope","$scope","HttpService","ToolService","UtilService",exportCtrl]);

    function exportCtrl($rootScope,$scope,HttpService,ToolService,UtilService){
        $scope.UserId = ToolService.getUser().id;

    	$scope.query = function(){
            ToolService.showLoading()
            var listPM = HttpService.getInfo("mng/export/report/"+$scope.appid+"/findall");
            listPM.then(function(data){
                $scope.donwlistData = data;
                ToolService.hideLoading();
            });
    	}

        $scope.$on('flipinfo',function(e,msg){
            $scope.flipPage2 = msg;
        });

    	$scope.doRemove = function(id){
            $scope.delstatus = true;
            $scope.delId = id;
        }
        $scope.removeInfo = function(){
            var url = "mng/export/report/"+$scope.appid+"/delete/"+$scope.delId,
                removePM = HttpService.deleteInfo(url);

            ToolService.showLoading();
            $scope.delstatus = false;
            removePM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips("删除成功")
                $scope.query();
            });
        }

        //失败刷新
        $scope.downlistRefresh = function(id,flag){
            if(flag && flag == 1){ //下载刷新
                id = $scope.winID;
            }
            ToolService.showLoading();
            $scope.closeWin();
            HttpService.putInfo("mng/export/report/"+$scope.appid+"/refresh/"+id,{}).then(function(data){
                $scope.query();
            });
        }
        $scope.closeWin = function(){
            ToolService.hideAlp();
            $scope.wantRefresh = false;
        }
        //下载列表下载文件
        $scope.downlistEvt = function(info){
            if(info.status!='complete'){return false;}
            var id = info.id;

            var downPM =  HttpService.downFile("mng/export/report/"+$scope.appid+"/download/"+id);
            ToolService.showLoading();
            downPM.then(function(data){
                ToolService.hideLoading();

                if(data.code == -1){
                    $scope.wantRefresh = true;
                    $scope.winID = info.id;
                    ToolService.showAlp();
                }else{
                    $rootScope.operSubmitData("下载");
                }
            });
        }

        $scope.$watch("appid",function(n){
            if(angular.isDefined(n)){
                $scope.query();
            }
        });
    }
})();
