(function(){
    var tempVersion = new Date().getTime();

    angular.module("app.collect")
        .config(['$stateProvider',"$urlRouterProvider",function ($stateProvider,$urlRouterProvider) {

        var menu = "collect",html = ["retention","funnel","export","intelligentpath","eventstats","custommenu","logtool","report","expiration"];

        var hasDetail = [];
        $stateProvider.state(menu,{
            url:"",
            templateUrl: '/template/menu/'+menu+'.html?r='+tempVersion,
            controller: "collectCtrl"
        });

        html.forEach(function(h){
            $stateProvider.state(menu + '.' + h,{
                url:"/" + menu + "/" + h,
                params:{
                    stateinfo:null,
                    pageid:null
                },
                views:{
                    "content@":{
                        templateUrl: "/template/" + menu + "/" + h + '.html?r='+tempVersion,
                        controller: h +"Ctrl"
                    }
                }
            });

            if(hasDetail.indexOf(h)>-1){
                var v = h+"Detail";
                $stateProvider.state('collect.' + v,{
                    url:"/" + menu + "/" + v,
                    params:{
                        aid:null
                    },
                    views:{
                        "content@":{
                            templateUrl: "/template/" + menu + "/" + v + '.html?r='+tempVersion,
                            controller: v +"Ctrl"
                        }
                    }
                });
            }
        });

        //看单-左侧菜单调整
        $stateProvider.state(menu + '.custommenuDetail',{
            url:"/" + menu + "/custommenu/:pageid",
            views:{
                "content@":{
                    templateUrl: "/template/" + menu + '/custommenu.html?r='+tempVersion,
                    controller:"custommenuCtrl"
                }
            }
        });
    }]);
})();
