#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author  :fengliang
# @revision:2017-09-01
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")


INPUT_PATH="${DM_INSTALL_LIST}/$date_path/adserver"
OUTPUT_PATH="${DM_INSTALL_LIST}_v2/$date_path/adserver"

exit 0
check_await $INPUT_PATH/_SUCCESS

hadoop fs -rm -r $OUTPUT_PATH


hadoop jar ../${JAR} mobvista.dmp.main.ParseInstallRCFile $INPUT_PATH $OUTPUT_PATH 100
if [ $? -ne 0 ];then
  exit 255
fi



mount_partition "dm_install_list_v2" "dt='$LOG_TIME', business='adserver'" "$OUTPUT_PATH"
if [ $? -ne 0 ];then
  exit 255
fi