#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : adn_device_ids_daily.sh
# @author: chao.wu
# @date  : 16-12-02
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_ADN_DSP_PATH="$ETL_ADN_ORG_REQ_HOURS/$year/$month/$day"
OUTPUT_PATH="$DMP_ADN_REQUEST_DEVICE_IDS/$year/$month/$day/adn_request"

## REDUCE_NUM=$(calculate_reduce_num "$INPUT_ADN_DSP_PATH")

hadoop fs -rm -r ${OUTPUT_PATH}/*
export HADOOP_CLIENT_OPTS="-Xmx2096m $HADOOP_CLIENT_OPTS"

hadoop jar ../${JAR} mobvista.dmp.datasource.adn.mapreduce.AdnDeviceIdsMR \
    -Dmapreduce.job.reduces=200 \
    -Dmapreduce.map.memory.mb=4096 \
    -Dmapreduce.map.java.opts=-Xmx2458m \
    -Dmapreduce.reduce.memory.mb=4096 \
    -Dmapreduce.reduce.java.opts=-Xmx2458m \
    -Dtask.date="$year-$month-$day" \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_ADN_DSP_PATH" "$OUTPUT_PATH" || exit 1

mount_partition "etl_ids_mapping" "year='$year', month='$month', day='$day', business='adn_request' " "$OUTPUT_PATH"

echo "[Adn request ids daily Tag End!]"


