#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :calc_device_age.sh
# @author  :liushuai
# @revision:2017-02-22 20:09
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_PATH="${AGE_MERGE_INSTALL}/${year}/${month}/${day}/"
OUTPUT_PATH="${AGE_CALC_DEVICE}/${year}/${month}/${day}/"
OUTPUT_PATH_V2="${AGE_CALC_DEVICE}_v2/${year}/${month}/${day}/"
FILEDICT="${AGE_CALC_PACKAGE_DICT}/${year}/${month}/${day}/part-r-00000"

hadoop fs -rm -r ${OUTPUT_PATH}
hadoop fs -rm -r ${OUTPUT_PATH_V2}

hadoop jar ../${JAR} mobvista.dmp.datasource.age.mapreduce.CalcDeviceAgeMR \
	-DoutPath=${OUTPUT_PATH} -DoutPath_v2=${OUTPUT_PATH_V2} "${INPUT_PATH}" "${OUTPUT_PATH}" "${FILEDICT}"
if [ $? -ne 0 ];then
   exit 255
fi

mount_partition "dm_device_age" "year='${year}', month='${month}', day='${day}'" "${OUTPUT_PATH}"

mount_partition "dm_device_age_v2" "year='${year}', month='${month}', day='${day}'" "${OUTPUT_PATH_V2}"
