#! /bin/bash


# # # # # # # # # # # # # # # # # # # # # #
# @file    :calc_package_age.sh
# @author  :liushuai
# @revision:2017-02-22 20:20
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_PATH="${AGE_MERGE_INSTALL}/${year}/${month}/${day}/"
OUTPUT_PATH="${AGE_CALC_PACKAGE}/${year}/${month}/${day}/"

REDUCE_NUM=$(calculate_reduce_num ${INPUT_PATH})

hadoop fs -rm -r ${OUTPUT_PATH}
hadoop jar ../${JAR} mobvista.dmp.datasource.age.mapreduce.CalcPackageAgeMR \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    "${INPUT_PATH}" "${OUTPUT_PATH}"  || exit 1
