#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author  :wangjf
# @revision:2019-08-28 17:36:39
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "$ScheduleTime")
date_path=$(date +%Y/%m/%d -d "$ScheduleTime")

business="ali"

INPUT_PATH="${DM_INSTALL_LIST}/$date_path/${business}"
OUTPUT_PATH="${DM_INSTALL_LIST}_v2/$date_path/${business}"

check_await ${INPUT_PATH}/_SUCCESS

hadoop fs -rm -r ${OUTPUT_PATH}

REDUCE_NUM=$(calculate_reduce_num ${INPUT_PATH})

export HADOOP_USER_CLASSPATH_FIRST=yes
export HADOOP_CLASSPATH="${HADOOP_CLASSPATH}:/data/hadoop-alternative/hive/lib/*"
hadoop jar ../${JAR} mobvista.dmp.main.ParseInstallRCFile \
  -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
  ${INPUT_PATH} ${OUTPUT_PATH} 100

: '
spark-submit --class mobvista.dmp.datasource.dm.DmInstallListOrc \
     --name "mobvista.dmp.datasource.dm.DmInstallListOrc.${business}" \
     --conf spark.yarn.executor.memoryOverhead=2048 \
     --conf spark.default.parallelism=500 \
     --conf spark.speculation=true \
     --conf spark.speculation.quantile=0.8 \
     --conf spark.speculation.multiplier=1.2 \
     --files ${HIVE_SITE_PATH} \
     --jars /data/hadoop-alternative/hive/auxlib/Common-SerDe-1.0-SNAPSHOT.jar \
     --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 4g  --executor-cores 3  --num-executors 80 \
     ../${JAR} \
     -output ${OUTPUT_PATH} -input ${INPUT_PATH} -business ${business}

if [ $? -ne 0 ];then
  exit 255
fi
'

unset HADOOP_CLASSPATH

mount_partition "dm_install_list_v2" "dt='$LOG_TIME', business='${business}'" "$OUTPUT_PATH"

if [[ $? -ne 0 ]];then
  exit 255
fi