#!/usr/bin/env bash

source ../../dmp_env.sh

dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")

ALI_USER_TO_3S_RES_PATH="${ALI_USERINFO_TO_3S_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USER_TO_3S_RES_PATH}"
ALI_USER_ACTIVATION_SYS_TO3S_PATH="$ALI_USER_ACTIVATION_SYS_TO3S/${dt_slash_today}"

mkdir kuaishou
cd kuaishou
#推快手数据
hadoop fs -test -e ${ALI_USER_TO_3S_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USER_TO_3S_RES_PATH}
fi

dirs=$(hadoop fs -ls ${ALI_USER_ACTIVATION_SYS_TO3S_PATH} | awk -F'/' '{print $12}' | grep  -E "imei|idfa|oaid")
for path in $dirs;do
  hadoop fs -text  ${ALI_USER_ACTIVATION_SYS_TO3S_PATH}/${path}/* > ${path}.kuaishoucsv
  split -b 500m  ${path}.kuaishoucsv  -d -a 2 ${path}_
  hadoop fs -put ${path}_* "${ALI_USER_TO_3S_RES_PATH}/"
  rm -f ${path}*
done


hadoop fs -touchz ${ALI_USER_TO_3S_RES_PATH}/_SUCCESS

if [ $? -ne 0 ];then
  exit 255
fi

rm -rf kuaishou
echo "good job~~"
