#!/usr/bin/env bash

source ../../dmp_env.sh

dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")


ALI_USER_TO_3S_TOUTIAO_RES_PATH="${ALI_USERINFO_TO_3S_TOUTIAO_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}"
ALI_USER_ACTIVATION_SYS_TO3S_PATH="$ALI_USER_ACTIVATION_SYS_TO3S/${dt_slash_today}"

rm -rf totiao
mkdir totiao
cd totiao
#推头条数据
hadoop fs -test -e ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}
fi

#需求变动，头条只要H_17人群包
#增加推送人群包H_44，H_45 2020.12.04
dirs=$(hadoop fs -ls ${ALI_USER_ACTIVATION_SYS_TO3S_PATH} | awk -F'/' '{print $12}' | grep  -E "imei|idfa|oaid"| grep -E "H_17|H_44|H_45|H_46|H_47|H_48|H_49|H_50|H_51|H_52|H_53|H_54|H_55|H_56|H_57|H_58|H_59|H_60|H_61|H_62|H_63|H_64|H_65")
for path in $dirs;do
  hadoop fs -text  ${ALI_USER_ACTIVATION_SYS_TO3S_PATH}/${path}/* > ${path}.totiaocsv
  split -b 55m  ${path}.totiaocsv  -d -a 2 ${path}_
  for new_path in $(ls ${path}_*)
  do
     echo ${new_path}
     device_id=$(echo ${new_path}|awk -F '_' '{print $(NF-1)}')
     echo $device_id
     result_path=${new_path#*_}
     java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${result_path}_1 ${device_id}
     zip ${result_path}_1.zip ${result_path}_1
     hadoop fs -put ${result_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
     rm -f ${new_path} ${result_path}*
  done
  rm -f ${path}.totiaocsv
done

hadoop fs -touchz ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/_SUCCESS
rm -rf totiao
