#!/usr/bin/env bash


source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime" +"%Y/%m/%d")
hour="04"

IMEIMD5_INPUT="${ALIPAY_LAHUO_DAILY_PATH}/$date_path/imeimd5_request_data/${hour}"

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dmp"
table="alipay_lahuo_daily"


spark-submit --class mobvista.dmp.datasource.taobao.AlipayImeiLaHuoCK \
     --name "AlipayImeiLaHuoCK.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=100 \
     --conf spark.default.parallelism=100 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf hive.exec.orc.split.strategy="BI" \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --conf hive.exec.orc.default.stripe.size=268435456 \
     --conf spark.sql.files.maxPartitionBytes=268435456 \
     --files ${HIVE_SITE_PATH} \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 10 \
     ../../${JAR} -imeiInput ${IMEIMD5_INPUT}  -date ${LOG_TIME} -host ${host} -cluster ${cluster} -database ${database} -table ${table} -hour ${hour}

if [[ $? -ne 0 ]];then
  exit 255
fi