#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")

## 等待爱奇艺拉货设备入库dm_install_list_v2
DMP_INSTALL_LIST_OUTPUT_PATH="${DM_INSTALL_LIST}_v2/${dt_slash_today}/iqiyi_activation"
check_await "${DMP_INSTALL_LIST_OUTPUT_PATH}/_SUCCESS"

ALI_IQIYI_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/iqiyi_lahuo"
mount_partition "gdt_data" "day='${dt_today}', category='iqiyi_lahuo', business='total'" "${ALI_IQIYI_LAHUO_SYS_TO3S_PATH}"

ALI_IQIYI_NOT_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/iqiyi_not_lahuo"
mount_partition "gdt_data" "day='${dt_today}', category='iqiyi_not_lahuo', business='total'" "${ALI_IQIYI_NOT_LAHUO_SYS_TO3S_PATH}"


ALI_IQIYI_LAHUO_APPEND_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/iqiyi_lahuo_append"
mount_partition "gdt_data" "day='${dt_today}', category='iqiyi_lahuo_append', business='total'" "${ALI_IQIYI_LAHUO_APPEND_SYS_TO3S_PATH}"

ALI_IQIYI_NOT_LAHUO_APPEND_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/iqiyi_not_lahuo_append"
mount_partition "gdt_data" "day='${dt_today}', category='iqiyi_not_lahuo_append', business='total'" "${ALI_IQIYI_NOT_LAHUO_APPEND_SYS_TO3S_PATH}"


ALI_IQIYI_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/iqiyi_lahuo_delete"
mount_partition "gdt_data" "day='${dt_today}', category='iqiyi_lahuo_delete', business='total'" "${ALI_IQIYI_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_IQIYI_NOT_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/iqiyi_not_lahuo_delete"
mount_partition "gdt_data" "day='${dt_today}', category='iqiyi_not_lahuo_delete', business='total'" "${ALI_IQIYI_NOT_LAHUO_DELETE_SYS_TO3S_PATH}"



HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar  dt_yesterday ${dt_yesterday}  -f iqiyi_lahuo_data_to_guangdiantong.sql

if [ $? -ne 0 ];then
  exit 255
fi


mkdir iqiyi_guangdiantong
cd iqiyi_guangdiantong

ALI_USERINFO_TO_3S_IQIYI_RES_PATH="${ALI_USERINFO_TO_3S_IQIYI_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_IQIYI_RES_PATH}"
#爱奇艺推广点通数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_IQIYI_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_IQIYI_RES_PATH}
fi

#拉活
hadoop fs -text  ${ALI_IQIYI_LAHUO_SYS_TO3S_PATH}/* > IQY_1_HASH_IMEI.csv
split -b 160m  IQY_1_HASH_IMEI.csv  -d -a 2 IQY_1_HASH_IMEI_
for new_path in $(ls IQY_1_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_IQIYI_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  IQY_1_HASH_IMEI.csv
#不拉活
hadoop fs -text  ${ALI_IQIYI_NOT_LAHUO_SYS_TO3S_PATH}/* > IQY_0_HASH_IMEI.csv
split -b 160m  IQY_0_HASH_IMEI.csv  -d -a 2 IQY_0_HASH_IMEI_
for new_path in $(ls IQY_0_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_IQIYI_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  IQY_0_HASH_IMEI.csv

hadoop fs -touchz ${ALI_USERINFO_TO_3S_IQIYI_RES_PATH}/_SUCCESS


ALI_USERINFO_TO_3S_IQIYI_APPEND_RES_PATH="${ALI_USERINFO_TO_3S_IQIYI_APPEND_PATH}/${dt_slash_today}"
ALI_USERINFO_TO_3S_IQIYI_DELETE_RES_PATH="${ALI_USERINFO_TO_3S_IQIYI_DELETE_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_IQIYI_APPEND_RES_PATH}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_IQIYI_DELETE_RES_PATH}"


#爱奇艺推广点通追加数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_IQIYI_APPEND_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_IQIYI_APPEND_RES_PATH}
fi

#拉活
hadoop fs -text  ${ALI_IQIYI_LAHUO_APPEND_SYS_TO3S_PATH}/* > IQY_1_HASH_IMEI.csv
split -b 160m  IQY_1_HASH_IMEI.csv  -d -a 2 IQY_1_HASH_IMEI_
for new_path in $(ls IQY_1_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_IQIYI_APPEND_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  IQY_1_HASH_IMEI.csv
#不拉活
hadoop fs -text  ${ALI_IQIYI_NOT_LAHUO_APPEND_SYS_TO3S_PATH}/* > IQY_0_HASH_IMEI.csv
split -b 160m  IQY_0_HASH_IMEI.csv  -d -a 2 IQY_0_HASH_IMEI_
for new_path in $(ls IQY_0_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_IQIYI_APPEND_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  IQY_0_HASH_IMEI.csv


hadoop fs -touchz ${ALI_USERINFO_TO_3S_IQIYI_APPEND_RES_PATH}/_SUCCESS


#爱奇艺推广点通删除数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_IQIYI_DELETE_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_IQIYI_DELETE_RES_PATH}
fi

#拉活
hadoop fs -text  ${ALI_IQIYI_LAHUO_DELETE_SYS_TO3S_PATH}/* > IQY_1_HASH_IMEI.csv
split -b 160m  IQY_1_HASH_IMEI.csv  -d -a 2 IQY_1_HASH_IMEI_
for new_path in $(ls IQY_1_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_IQIYI_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  IQY_1_HASH_IMEI.csv
#不拉活
hadoop fs -text  ${ALI_IQIYI_NOT_LAHUO_DELETE_SYS_TO3S_PATH}/* > IQY_0_HASH_IMEI.csv
split -b 160m  IQY_0_HASH_IMEI.csv  -d -a 2 IQY_0_HASH_IMEI_
for new_path in $(ls IQY_0_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_IQIYI_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  IQY_0_HASH_IMEI.csv

hadoop fs -touchz ${ALI_USERINFO_TO_3S_IQIYI_DELETE_RES_PATH}/_SUCCESS

rm -rf iqiyi_guangdiantong
echo "good job~~"


