#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : jiangfan
# @date : 2021-07-01 12:06:00
# # # # # # # # # # # # # # # # # # # # # #
#!/usr/bin/env bash

source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")


OUTPUT_PATH="${REYUN_LABEL_BAIJIU_DAILY_PATH}/${dt_slash_today}"

hadoop fs -rm -r "${OUTPUT_PATH}"

spark-submit --class mobvista.dmp.datasource.reyun.ReyunLabelBaijiu \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.network.timeout=720s \
 --conf spark.driver.maxResultSize=4g \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --files ${HIVE_SITE_PATH} \
 --jars ${JARS} \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 4g  --executor-cores 4  --num-executors 170 \
 ../../${JAR}  \
 -output ${OUTPUT_PATH} -coalesce 680  -dt_today ${dt_today}

if [[ $? -ne 0 ]];then
  exit 255
fi

