#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : interest_tag_other.sh
# @author: houying
# @date  : 17-3-15
# # # # # # # # # # # # # # # # # # # # # # 

source ../dmp_env.sh

BASE_PATH="$(cd "$(dirname $0)";pwd)"

LOG_TIME=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_INSTALL_PATH="${DM_INSTALL_LIST}/${year}/${month}/${day}/other"
INPUT_APP_TAG_PATH="$APP_TAG_PATH/${year}/${month}/${day}/"
OUTPUT_PATH="${DM_INTEREST_PATH}/${year}/${month}/${day}/other"

check_await "$INPUT_APP_TAG_PATH/_SUCCESS"
check_await "$INPUT_INSTALL_PATH/_SUCCESS"

REDUCE_NUM=$(calculate_reduce_num "$INPUT_INSTALL_PATH")

haodop fs -rmr $OUTPUT_PATH

hadoop jar ../${JAR} mobvista.dmp.common.InterestDeviceDistinctMR \
      -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
      -Dmapreduce.map.memory.mb=4072 \
      -Dmapreduce.map.java.opts=-Xmx3458m \
      -Dmapreduce.reduce.memory.mb=4072 \
      -Dmapreduce.reduce.java.opts=-Xmx3458m \
      -Dmapred.max.split.size=536870912 \
      -Dmapred.min.split.size.per.node=536870912 \
      -Dmapred.min.split.size.per.rack=536870912 \
      -Dmapreduce.job.reduces=200 \
      "$INPUT_APP_TAG_PATH/part-r-00000" "$INPUT_INSTALL_PATH" "$OUTPUT_PATH" "other install interest job" \

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition dm_interest_tag "year='$year',month='$month',day='$day',business='other'" "$OUTPUT_PATH"
