#!/bin/sh

source ~/.bash_profile

THIS="$0"

while [ -h "$THIS" ]; do
ls=`ls -ld "$THIS"`
link=`expr "$ls" : '.*-> \(.*\)$'`
if expr "$link" : '.*/.*' > /dev/null; then
THIS="$link"
else
THIS=`dirname "$THIS"`/"$link"
fi
done

THIS_DIR=`dirname "$THIS"`
PROJECT_HOME=`cd "$THIS_DIR/.."; pwd`
cd $PROJECT_HOME

startDay='20180612'
stopDay='20180702'

while [ $startDay -le $stopDay ];do
  export ScheduleTime="$startDay"
  cd $PROJECT_HOME/ga

  sh -x ga_data_preparing.sh
  if [ $? -ne 0 ];then
     python2.7 ../python/sendMail.py -t mingyuan.ren@mobvista.com  -c '516072575@qq.com' \
    -s "repair 失败" -b "repair 失败"
     exit 255
  fi

  sh -x ga_install_daily.sh
  if [ $? -ne 0 ];then
     python2.7 ../python/sendMail.py -t mingyuan.ren@mobvista.com  -c '516072575@qq.com' \
        -s "repair 失败" -b "repair 失败"
     exit 255
  fi

  sh -x ga_install_total.sh
  if [ $? -ne 0 ];then
     python2.7 ../python/sendMail.py -t mingyuan.ren@mobvista.com  -c '516072575@qq.com' \
        -s "repair 失败" -b "repair 失败"
     exit 255
  fi

  sh -x ga_install_total_v2.sh
  if [ $? -ne 0 ];then
     python2.7 ../python/sendMail.py -t mingyuan.ren@mobvista.com  -c '516072575@qq.com' \
        -s "repair 失败" -b "repair 失败"
     exit 255
  fi

  startDay=`date -d"$startDay 1 day" +"%Y%m%d"`
done