#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : ${NAME}
# @author: houying
# @date  : 17-3-14
# # # # # # # # # # # # # # # # # # # # # # 


source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

: <<'COMMENT'
DEVICE_PATH="$TMP_EGGPLANTS_INPUT_PATH/$year/$month/$day"

hadoop fs -rm -r "$DEVICE_PATH"
hadoop fs -mkdir -p "$DEVICE_PATH"
hive_cmd "
use dwh;
set hive.exec.reducers.max=10;
set mapreduce.reduce.memory.mb=1536;
set mapred.job.name=filter_eggplants_device_ying.hou;
insert overwrite directory '$DEVICE_PATH'
select imei,dev_id,gaid
from ods_adn_trackingnew_request
where yyyy='$year'
  and mm='$month'
  and dd='$day'
  and publisher_id='7894'
  and app_id='24178'
  and (imei!='0' or dev_id!='0')
  and gaid not in ('0','-')
group by imei, dev_id, gaid
"
COMMENT