#!/bin/bash

source  ../../ga_rawdata_analysis/common/tools.sh
source ././../../dmp_env.sh

today=${ScheduleTime:-$1}

echo "ScheduleTime=$ScheduleTime"
echo "toady=$today"

yes_date=$(date +%Y%m%d -d "-1 day $today")
yes_date_path=$(date +%Y/%m/%d -d "-1 day $today")
yes_date_before=$(date +%Y%m%d -d "-2 day $today")
yes_date_str_midline=$(date +%Y-%m-%d -d "-1 day $today")

OUTPUT_PATH=s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dmp_device_tag/${yes_date_path}/external/yunhai
hadoop fs -test -e ${OUTPUT_PATH}
if [ $? -ne 0 ];then
hadoop fs -mkdir -p  ${OUTPUT_PATH}
fi

mount_partition "dmp_device_tag" "dt='${yes_date}', source='external',business='yunhai'" "${OUTPUT_PATH}"


HIVE_CMD=$(hive_func)
$HIVE_CMD	  -v  -hivevar  	yes_date=$yes_date  -hivevar	 yes_date_before=$yes_date_before  -hivevar yes_date_str_midline=$yes_date_str_midline   -f	yunhaitao.sql

if [ $? -ne 0 ]; then
    exit 255
fi

