#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author  : kehan
# @revision: 2019-06-21
# @desc :  将当天 facebook install用户添加到ods_dmp_user_info表
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

today=${ScheduleTime:-$1}
dt=$(date +"%Y%m%d" -d "-1 day $today")
date=$(date +"%Y-%m-%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")
old_path=$(date +%Y/%m/%d -d "-2 day $today")
expire_date=$(date +%Y%m%d -d "-6 day $today")
expire_path=$(date +%Y/%m/%d -d "-6 day $today")

business_name="facebook"
daily_path="${FACEBOOK_DAILY_PATH}/$date_path"
age_path="${AGE_CALC_DEVICE}/$date_path"
gender_path="${GENDER_CALC_DEVICE}/$date_path"

old_total_path="${ODS_DMP_USER_INFO}/$old_path/${business_name}"
OUTPUT_PATH="${ODS_DMP_USER_INFO}/$date_path/${business_name}"
unmount_path="${ODS_DMP_USER_INFO}/$expire_path/${business_name}"

coalesce=`calculate_reduce_num "${old_total_path};${daily_path}"`
coalesce=$(( $coalesce*5 ))
check_await "${old_total_path}/_SUCCESS"

userInfoJob "$date" "$daily_path" "orc" "0" "2" "3" "5" "$age_path" "$gender_path" "$old_total_path" "$OUTPUT_PATH" ${coalesce} "../${JAR}" 20 10

mount_partition "ods_dmp_user_info" "dt='${dt}', business='${business_name}'" "$OUTPUT_PATH"

unmount_partition "ods_dmp_user_info" "dt='${expire_date}', business='${business_name}'" "$unmount_path"