#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : ga_install_total.sh
# @author: houying
# @date  : 16-11-8
# # # # # # # # # # # # # # # # # # # # # # 


source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_INSTALL_DAILY_PATH="$GA_INSTALL_PATH/$year/$month/$day"
INPUT_INSTALL_TOTAL_PATH=$(get_recently_dir "$DM_INSTALL_LIST" "$YESTERDAY" "ga")
OUTPUT="$DM_INSTALL_LIST/$year/$month/$day/ga"

hadoop fs -rm -r "$OUTPUT/*"
REDUCE_NUM=$(calculate_reduce_num "$INPUT_INSTALL_TOTAL_PATH")

hadoop jar ../${JAR} mobvista.dmp.datasource.ga.mapreduce.GaInstallTotalMR \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    -Dtask.date=${year}-${month}-${day} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_INSTALL_DAILY_PATH" "$INPUT_INSTALL_TOTAL_PATH" "$OUTPUT" || exit 1
if [ $? -ne 0 ]; then
    exit 255
fi
mount_partition "dm_install_list" "year='$year', month='$month', day='$day', business='ga'" "$OUTPUT"

echo "[Ga Install List Total End!]"
