#!/bin/bash
source ./common/tools.sh

today=${ScheduleTime:-$1}

echo "ScheduleTime=$ScheduleTime"
echo "toady=$today"

date_path=$(date +%Y/%m/%d -d "-1 day $today")
date_str_undline=$(date +%Y_%m_%d -d "-1 day $today")
date_str_midline=$(date +%Y-%m-%d -d "-1 day $today")

HIVE_CMD=$(hive_func)

hadoop fs -test -e s3://mob-emr-test/dataplatform/emr/event_export/event_export_${date_str_undline}
if [ $? -ne 0 ]; then
  hadoop fs -mkdir -p s3://mob-emr-test/dataplatform/emr/event_export/event_export_${date_str_undline}
fi

$HIVE_CMD -v -hivevar prefix=$date_path -hivevar date_str_undline=$date_str_undline -hivevar date_str_midline=$date_str_midline -f export_hours.sql
