#!/bin/bash

source ../dmp_env.sh

region=$1
today=${ScheduleTime:-$2}

datetime=$(date +"%Y/%m/%d %H" -d "1 hour ago $today")
date=${datetime:0:10}
hour=${datetime:11:2}

date_path="${date}/${region}/${hour}"

sleep 10

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dwc"
table="realtime_service_result"

S3_OUTPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dev/realtime_service_device/${date_path}"

if [[ ${region} == "cn" ]]; then
    partition=10
    cores=2
else
    partition=100
    cores=4
fi

spark-submit --class mobvista.dmp.clickhouse.realtime.ReadFromCKWriteCS \
     --name "ReadFromCKWriteCS_${date}_${hour}_${region}" \
     --conf spark.sql.shuffle.partitions=${partition} \
     --conf spark.default.parallelism=${partition} \
     --conf spark.sql.files.maxPartitionBytes=33554432 \
     --conf spark.yarn.executor.memoryOverhead=2048 \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --files ${HIVE_SITE_PATH} \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 2g --executor-cores 2 --num-executors ${cores} \
     ../${JAR} \
     -date ${date} -hour ${hour} -region ${region} -host ${host} -cluster ${cluster} -database ${database} -table ${table} --output ${S3_OUTPUT} -part ${partition}

if [[ $? -ne 0 ]]; then
    exit 255
fi