#!/bin/bash

source ../dmp_env.sh

date_utime=$1

today=${ScheduleTime}

date_time=$(date +"%Y-%m-%d %H" -d "-1 hour $today")

date_path=$(date +%Y/%m/%d/%H -d "-1 hour $today")

OUTPUT="s3://mob-emr-test/dataplatform/rtdmp_base_test/${date_path}"

# --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
spark-submit --class mobvista.dmp.datasource.rtdmp.RTDmpMain \
     --name "RTDmpMain.wangjf.${date_time}" \
     --conf spark.sql.shuffle.partitions=2000 \
     --conf spark.default.parallelism=2000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.speculation=true \
     --conf spark.speculation.quantile=0.9 \
     --conf spark.speculation.multiplier=1.3 \
     --jars ${SPARK_HOME}/auxlib/Common-SerDe-1.0-SNAPSHOT.jar \
     --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 6g  --executor-cores 3 --num-executors 20 \
     ../${JAR} -time "${date_time}" -data_utime "${date_time}" -output ${OUTPUT} -coalesce 100 -partition 2000

if [[ $? -ne 0 ]]; then
    exit 255
fi