#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :create_table.sh
# @author  :liushuai
# @revision:2017-03-14 20:09
# # # # # # # # # # # # # # # # # # # # # #

source ../prd_env.sh

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

rm *.txt
hadoop fs -get s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table/*.txt

java -cp ../${JAR} mobvista.prd.datasource.table.CreateMAppTable ${LOG_TIME}
if [ $? -ne 0 ];then
  exit 255
fi

java -cp ../${JAR} mobvista.prd.datasource.table.CreateDspAppTable
if [ $? -ne 0 ];then
  exit 255
fi

hadoop fs -mkdir -p s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table

hadoop fs -rm s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table/M系统指定app的国家性别年龄.xls
hadoop fs -rm s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table/DSP指定app的国家性别年龄.xls

hadoop fs -put M系统指定app的国家性别年龄.xls s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table
hadoop fs -put DSP指定app的国家性别年龄.xls s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table