#!/bin/bash

source ../prd_env.sh
date_path=$(date +"%Y/%m/%d" -d "-2 day $ScheduleTime")

REPORT_PATH="s3://mob-emr-test/liushuai/prd/${date_path}/table"

rm *.xls
hadoop fs -get $REPORT_PATH/*.xls
if [ $? -ne 0 ];then
  exit 255
fi

file_num=`ls *.xls | wc -l`
if [ $file_num -lt 7 ];then
   echo "report file numbers error"
   exit 255
fi

files=""
reports=`ls *.xls`
for r in $reports;do
  files="$files,$r"
done

python2.7 ../python/sendMail.py -t mingyuan.ren@mobvista.com  -c 'walt@mobvista.com,feng.liang@mobvista.com,kai.liu@mobvista.com,xianle.cao@mobvista.com' \
-s "周一数据报表-$LOG_TIME" -b "hi，明远<br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;周一报表数据见附件<br/><br/>" -a ${files:1}

rm *.xls


sql="
 use dev;
 drop table tmp_dmp;
 drop table app_gender_age;
 drop table tmp_dmp_and_dsp;
 drop table tmp_dmp_and_m;
 drop table dsp_app_gender_age;
"
hive_cmd "$sql"
