#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :dsp_count_country_interest.sh
# @author  :liushuai
# @revision:2017-05-17 20:09
# @desc    ：dsp 兴趣 标签设备量
# # # # # # # # # # # # # # # # # # # # # #

source ../prd_env.sh

echo "ScheduleTime=$ScheduleTime"
LOG_TIME=$(date +%Y%m%d -d "-2 days $ScheduleTime")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

date_path=${LOG_TIME:0:4}/${LOG_TIME:4:2}/${LOG_TIME:6:2}

DSP_PATH="${REQUEST_PATH}/dsp_count_interest/$date_path/"
M_PATH="${REQUEST_PATH}/m_count_interest/$date_path/"
DMP_PATH="${REQUEST_PATH}/all_count_country_interest/$date_path"
REPORT_PATH="s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/table"

hadoop fs -text ${DSP_PATH}/* > dspCountryInterest.txt
hadoop fs -text ${M_PATH}/* > mCountInterest.txt
hadoop fs -text ${DMP_PATH}/* > dmpCountInterest.txt

perl -pi -e 's|\001|\t|g' dmpCountInterest.txt

java -cp ../${JAR} mobvista.prd.datasource.country.interest.mapreduce.CreateCountryInterestTable ./dspCountryInterest.txt ./DSP分国家兴趣.xls
if [ $? -ne 0 ];then
  exit 255
fi

java -cp ../${JAR} mobvista.prd.datasource.country.interest.mapreduce.CreateCountryInterestTable ./mCountInterest.txt ./M系统分国家兴趣.xls
if [ $? -ne 0 ];then
  exit 255
fi

java -cp ../${JAR} mobvista.prd.datasource.country.interest.mapreduce.CreateCountryInterestTable ./dmpCountInterest.txt ./DMP整体分国家兴趣.xls
if [ $? -ne 0 ];then
  exit 255
fi


hadoop fs -mkdir -p $REPORT_PATH
hadoop fs -rm $REPORT_PATH/DSP分国家兴趣.xls
hadoop fs -rm $REPORT_PATH/M系统分国家兴趣.xls
hadoop fs -rm $REPORT_PATH/DMP整体分国家兴趣.xls
hadoop fs -put *国家兴趣.xls $REPORT_PATH