#!/bin/bash

######################################################################
# autor: fengliang
# date:  20170518
# desc:  计算年兴趣标签数据各个年龄段儿的样本量和算法推荐量
######################################################################

source ../prd_env.sh

echo "ScheduleTime=$ScheduleTime"
date=$(date +"%Y-%m-%d" -d "-1 days $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 days $ScheduleTime")

#
#INPUT_PATH="$DM_INTEREST_PATH/$date_path/all/"
#OUTPUT_PATH="$REPORT_INTEREST_TAG_RESULT_PATH/$date_path/"
#COUNTRY_OUTPUT_PATH="${REPORT_INTEREST_TAG_CNT_RESULT_PATH}/$date_path"


#     val date = args(0)
#      val appTagPath = args(1)
#      val installPath = args(2)
#      val outputPath = args(4)

appTagPath="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dim_app_tag/${date_path}"
installPath="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_install_list/${date_path}/*"
outputPath="s3://mob-emr-test/feng.liang/report/activeInstall"

spark-submit --master yarn  --executor-cores 2 --executor-memory 4g \
--class mobvista.prd.main.ActiveInstall --driver-memory 4g ../${JAR} \
$date $appTagPath $installPath $outputPath

if [ $? -ne 0 ];then
  exit 255
fi