#!/usr/bin/env bash

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

source ../prd_env.sh

INPUT_PATH="${REQUEST_TMP_PATH}/dsp_join_m_1_day/${year}/${month}/${day}/"
iosFile="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dim_app_info_ios/${year}/${month}/${day}/"
adrFile="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dim_app_info_adr/${year}/${month}/${day}/"
OUTPUT="${REQUEST_PATH}/count_dsp_join_m_1_day/${year}/${month}/${day}/"

hadoop fs -rmr ${OUTPUT}

hadoop jar ../${JAR} mobvista.prd.datasource.source.mapreduce.CountDspJoinMMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -input ${INPUT_PATH} \
    -output ${OUTPUT} \
    -reduceNum 1 \
    -iosFile "${iosFile}" \
    -adrFile "${adrFile}"

if [ $? -ne 0 ];then
  exit 255
fi