#!/usr/bin/env bash

source ././../prd_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

now=`date -d"$ScheduleTime" +%w`

if [ $now -eq 2 ] || [ $now -eq 3 ] || [ $now -eq 5 ] || [ $now -eq 6 ] || [ $now -eq 0 ]; then
    echo "$LOG_TIME is not Monday or Thursday"
    exit 0
fi

INPUT="${ADN_TOTAL_PATH}/${year}/${month}/${day}"
OUTPUT="s3://mob-emr-test/liushuai/eggplants/${year}/${month}/${day}"
FILE="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/tmp/eggplants/output/2017/"

check_await "$INPUT/_SUCCESS"

hadoop fs -rmr ${OUTPUT}

hadoop jar ../DMP.jar mobvista.prd.datasource.eggplants.EggplantsAppCountryAllMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    ${INPUT} ${FILE} ${OUTPUT}

if [ $? -ne 0 ]; then
    exit 255
fi