#!/usr/bin/env bash
source ../prd_env.sh

echo "ScheduleTime=$ScheduleTime"
date=$(date +"%Y-%m-%d" -d "-1 days $ScheduleTime")
date_path=$(date +"%Y/%m/%d" -d "-1 days $ScheduleTime")



hql="
use dwh;
create table tmp_device_daily_20170725 as
select t.device_id, t.device_type
from (
  SELECT
    t.device_id,
    t.device_type
  FROM 3s_install_daily t

  UNION ALL

  SELECT
    t.device_id,
    t.device_type
  FROM ad_server_daily t

  UNION ALL

  SELECT
    t.device_id,
    t.device_type
  FROM adn_install_daily t

  UNION ALL

  SELECT
    t.device_id,
    t.device_type
  FROM etl_adn_sdk_request_daily t
  WHERE t.date = '20170725'

  UNION ALL

  SELECT
    t.device_id,
    t.device_type
  FROM etl_dsp_request_daily t
  WHERE t.date = '2017-07-25'

  UNION ALL

  SELECT
    t.device_id,
    t.device_type
  FROM ods_ga_install_daily t
  WHERE t.date = '20170725'

  UNION ALL

  SELECT
    t.device_id,
    t.device_type
  FROM ods_ga_device_daily t
  WHERE t.date = '20170725'
) t
GROUP BY t.device_id, t.device_type;



create table tmp_tags_casino_20170725 as
  select t.device_id, t.device_type
  from dm_interest_tag t
  where t.year='2017' and t.month='07' and t.day='25'
        and t.tags like '%"Casino"%' and t.business not in ('all')
  GROUP BY t.device_id, t.device_type;


create table tmp_tags_dice_20170725 as
select t.device_id, t.device_type
from dm_interest_tag t
where t.year='2017' and t.month='07' and t.day='25'
and t.tags like '%"Dice"%' and t.business not in ('all')
GROUP BY t.device_id, t.device_type;


insert overwrite directory 's3://mob-emr-test/feng.liang/casino_new'
select c.country, count(1) as cnt
from tmp_device_daily_20170725 a
join tmp_tags_casino_20170725 b on a.device_id=b.device_id and a.device_type=b.device_type
join (
  select *
  from ods_dmp_device_total t
  where t.dt='20170726'
) c  on a.device_id=c.device_id and a.device_type=c.device_type
GROUP BY c.country;


insert overwrite directory 's3://mob-emr-test/feng.liang/dice_new'
select c.country, count(1) as cnt
from tmp_device_daily_20170725 a
  join tmp_tags_dice_20170725 b on a.device_id=b.device_id and a.device_type=b.device_type
  join (
         select *
         from ods_dmp_device_total t
         where t.dt='20170726'
       ) c  on a.device_id=c.device_id and a.device_type=c.device_type
GROUP BY c.country;


select count(1) as cnt
from tmp_device_daily_20170725 a
join tmp_tags_dice_20170725 b on a.device_id=b.device_id and a.device_type=b.device_type
WHERE b.device_id is null and b.device_type is null ;


select count(1) as cnt
from tmp_device_daily_20170725 a
JOIN (
select *
from ods_dmp_device_total t
where t.dt='20170726'
) c  on a.device_id=c.device_id and a.device_type=c.device_type
WHERE c.device_id is null and c.device_type is null and c.country is null;

"