#!/usr/bin/python2.7
# encoding:utf-8

import sys
import base64
import mimetypes
import optparse
import os.path
import smtplib
from email import encoders
from email.header import Header
from email.MIMEBase import MIMEBase
from email.MIMEMultipart import MIMEMultipart
from email.MIMEText import MIMEText


class SendMail:

    def create_text_mail(self, from_addr='monitor.dataPlatform@mobvista.com', to_addr=[], cc_addr=[], subject='', body=''):
        # 如果发送的是文本邮件，则第二个参数设置为plain
        # 如果发送的是html邮件，则第二个参数设置为html
        self.mail = MIMEText(body, 'plain', 'utf-8')
        self.mail['Subject'] = "=?UTF-8?B?"+base64.b64encode(subject)+"?="
        self.mail['From'] = from_addr
        self.mail['To'] = '; '.join(to_addr)
        self.mail['Cc'] = '; '.join(cc_addr)

        self.from_addr = from_addr
        self.to_addr = to_addr + cc_addr



    def create_mail(self, from_addr='monitor.dataPlatform@mobvista.com', to_addr=[], cc_addr=[], subject='', body=''):
        self.mail = MIMEMultipart()
        self.mail['From'] = from_addr
        self.mail['To'] = '; '.join(to_addr)
        self.mail['Cc'] = '; '.join(cc_addr)
        self.mail['Subject'] = "=?UTF-8?B?"+base64.b64encode(subject)+"?="
        self.mail.attach(MIMEText(body, 'html', 'UTF-8'))

        self.from_addr = from_addr
        self.to_addr = to_addr + cc_addr

    def add_attachment(self, files):
        for attachment in files:
            ctype, encoding = mimetypes.guess_type(attachment)
            maintype, subtype = ctype.split('/',1)

            fp = open(attachment, 'rb')
            msg = MIMEBase(maintype, subtype)
            msg.set_payload(fp.read())
            fp.close()
            encoders.encode_base64(msg)
            filename = os.path.basename(attachment)
            msg.add_header('Content-Disposition', 'attachment', filename=str(Header(filename, 'UTF-8')))
            self.mail.attach(msg)

    def send_mail(self, host='smtp.exmail.qq.com', username='monitor.dataPlatform@mobvista.com', password='dataPlatform1'):
        s = smtplib.SMTP(host, 587)
        s.starttls()
        s.login(username, password)
        s.sendmail(self.from_addr, self.to_addr, self.mail.as_string())
        s.quit()

if __name__ == '__main__':
    p = optparse.OptionParser()
    p.add_option('--from', '-f', dest='from_addr', default='monitor.dataPlatform@mobvista.com')
    p.add_option('--to', '-t')
    p.add_option('--cc', '-c')
    p.add_option('--host', '-o', default='smtp.exmail.qq.com')
    p.add_option('--username', '-u', default='monitor.dataPlatform@mobvista.com')
    p.add_option('--password', '-p', default='dataPlatform1')
    p.add_option('--subject', '-s', default='')
    p.add_option('--body', '-b', default='')
    p.add_option('--attachment', '-a')
    options, arguments = p.parse_args()

    to_user = []
    cc_user = []
    if options.to:
        to_user = options.to.split(',')
    if options.cc:
        cc_user = options.cc.split(',')

    sendmail = SendMail()
    sendmail.create_mail(options.from_addr, to_user, cc_user, options.subject, options.body)
    #sendmail.create_text_mail(options.from_addr, to_user, cc_user, options.subject, options.body)

    if options.attachment:
        attachments = options.attachment.split(',')
        sendmail.add_attachment(attachments)

    sendmail.send_mail(options.host, options.username, options.password)
