package mobvista.dmp.datasource.adn.mapreduce;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import mobvista.dmp.common.CommonMapReduce;
import mobvista.dmp.common.CommonMapper;
import mobvista.dmp.common.CommonReducer;
import mobvista.dmp.common.InstallTotalReducer;
import mobvista.dmp.util.MRUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * author: houying
 * date  : 16-11-8
 * desc  :
 */
public class AdnInstallTotalMR extends CommonMapReduce {

    public static class AdnInstallTotalMapper extends CommonMapper {
        private Pattern datePtn = Pattern.compile("/(\\d{4}/\\d{2}/\\d{2})");
        private String path;

        @Override
        protected void setup(Context context) throws IOException, InterruptedException {
            path = ((FileSplit) context.getInputSplit()).getPath().toString();
        }

        @Override
        protected void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
            String[] array = MRUtils.SPLITTER.split(value.toString(), -1);
            if (array.length >= 5) { // etl adn install daily
                if (Strings.isNullOrEmpty(array[4]) || CommonMapReduce.allZero.equals(array[0])) {  //新增 imei  && android_id
                    return;
                }

                outKey.set(MRUtils.JOINER.join(
                        array[0], //device_id
                        array[1], //device_type
                        array[2]  //platform
                ));

                Matcher m = datePtn.matcher(path);
                if (!m.find()) {
                    return;
                }
                String date = m.group(1).replace("/", "-");
                outValue.set(MRUtils.JOINER.join(
                        array[4], date //package_name  date
                ));
            } else if (array.length == 4) { //adn install list total
                outKey.set(MRUtils.JOINER.join(
                        array[0],
                        array[1],
                        array[2]
                ));
                outValue.set(array[3]); //json array
            } else {
                CommonMapReduce.setMetrics(context, "DMP", "column_num_error", 1);
                return;
            }
            context.write(outKey, outValue);
        }
    }

    public static void main(String[] args) throws Exception {
        start(new AdnInstallTotalMR("adn install total job", AdnInstallTotalMapper.class, InstallTotalReducer.class), args);
    }

    public AdnInstallTotalMR(String name, Class<? extends Mapper> mapperClass, Class<? extends Reducer> reducerClass) {
        super(name, mapperClass, reducerClass);
    }

    @Override
    protected void otherSetting(Job job, String[] args) {
        //为了取路径中的日期
        job.setInputFormatClass(TextInputFormat.class);
    }

    @Override
    protected void setOutputPath(Job job, String[] args) throws IOException {
        FileOutputFormat.setOutputPath(job, new Path(args[2]));
        FileOutputFormat.setCompressOutput(job, true);
        FileOutputFormat.setOutputCompressorClass(job, GzipCodec.class);
    }

    @Override
    protected void setInputPath(Job job, String[] args) throws IOException {
        FileInputFormat.addInputPath(job, new Path(args[0]));
        FileInputFormat.addInputPath(job, new Path(args[1]));
    }
}

