package mobvista.dmp.main;

import mobvista.prd.datasource.util.HttpUtil;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackageToName {

    public static final Map<String, String> lMap = new HashMap<>();
    public static final Map<String, String> cMap = new HashMap<>();
    static {
        lMap.put("USA", "en");
        lMap.put("JPN", "ja");
        lMap.put("KOR", "ko");
        lMap.put("CHN", "zh");
        lMap.put("IDN", "id");
        lMap.put("IND", "in");

        cMap.put("USA", "us");
        cMap.put("JPN", "jp");
        cMap.put("KOR", "kr");
        cMap.put("CHN", "cn");
        cMap.put("IDN", "id");
        cMap.put("IND", "in");
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream out = new FileOutputStream("/Users/fl/Desktop/bundle_app_name1.xls");
        POIFSFileSystem pfs = new POIFSFileSystem(new FileInputStream("/Users/fl/Desktop/bundle_app_name.xls"));
        HSSFWorkbook workbook = new HSSFWorkbook(pfs);
        HSSFSheet sheet = workbook.getSheetAt(0);
        List<String> llist = new ArrayList<>();
        List<String> list = new ArrayList<>();
        for (int i = 1; i < 179; i++) {
            String appName = null;
            Row row = sheet.getRow(i);
            String country = row.getCell(0).getStringCellValue();
            if (row.getCell(1).getCellType() == 0) {
                try {
                    appName = getIosAppName(country, (int)row.getCell(1).getNumericCellValue());
                    llist.add(country + "\t" + (int)row.getCell(1).getNumericCellValue() + "\t" + appName);
                } catch (Exception e) {
                    list.add(country + "\t" + (int)row.getCell(1).getNumericCellValue());
                }

            } else if (row.getCell(1).getCellType() == 1) {
                String packageName = row.getCell(1).getStringCellValue();
                try {
                    appName = getAdrAppName(country, packageName);
                    llist.add(country + "\t" + packageName + "\t" + appName);
                } catch (Exception e) {
                    list.add(country + "\t" + packageName);
                }

            }
        }

        for (String str : llist) {
            System.out.println(str);
        }
        System.out.println("0000000000000");
        for (String str : list) {
            System.out.println(str);
        }
    }

    public static String getAdrAppName (String country, String pkg) throws Exception {
        if ("com.cleanmaster.mguard".equals(pkg) && "IDN".equals(country)) {
            System.out.println();
        }
        String url = "https://play.google.com/store/apps/details?id=" + pkg + "&hl=" + lMap.get(country);
        String result = HttpUtil.getRequest(url, null, Logger.getLogger(UrlToName.class));
        Element element = Jsoup.parse(result).select("h1[itemprop=name] div").first();
        return element.text();
    }

    public static String getIosAppName (String country, int pkg) throws Exception {
        String url = "https://itunes.apple.com/"+ cMap.get(country) +"/app/id" + pkg;
        String result = HttpUtil.getRequest(url, null, Logger.getLogger(UrlToName.class));
        Element element = Jsoup.parse(result).select("h1[itemprop=name]").first();
        return element.text();
    }
}
