package mobvista.dmp.util;

import java.io.IOException;

import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.Text;

public class BytesRefUtil {

	public static String BytesRefWritableToString(BytesRefWritable b){
		Text txt=new Text();
		try {
			txt.set(b.getData(), b.getStart(), b.getLength());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return txt.toString();
	}
	public static BytesRefArrayWritable createRcOutValue(String src) {
		String[] datas = src.split("\t");
		BytesRefArrayWritable reduceValue = new BytesRefArrayWritable();
		BytesRefWritable[] arr = new BytesRefWritable[datas.length];
		for (int j = 0; j < arr.length; j++) {
			arr[j] = new BytesRefWritable();
			arr[j].set(datas[j].getBytes(), 0, datas[j].getBytes().length);
			reduceValue.set(j, arr[j]);
		}
		return reduceValue;
	}
	
	//二进制数组输出
	public static String braw2str(BytesRefArrayWritable braw) {
		StringBuilder strb = new StringBuilder();
		for (int i = 0; i < braw.size(); i++) {
			strb.append(BytesRefWritableToString(braw.get(i))).append("\t");
		}
		strb.delete(strb.length() - 1, strb.length());
		return strb.toString();
	}
	
}
