package mobvista.prd.datasource.dao;

import java.util.List;
import java.util.Map;

/**
 * Created by fl on 2017/5/15.
 */
public interface ExportExcelDAO extends DBCommonDAO {

    /**
     *
     * @param date
     * @param tagType
     * @param dataType  整体和分国家
     * @return
     * @throws Exception
     */
    public List<Map<String, Object>> findDataByTag(String date, String tagType, String dataType) throws Exception;


    /**
     *
     * @param date
     * @param dataType  整体和分国家
     * @return
     * @throws Exception
     */
    public List<Map<String, Object>> findInterestTagData (String date, String dataType) throws Exception;


    /**
     * 查询M系统分国家、app和平台DAU
     *
     * @param country
     * @param appId
     * @param date
     * @param platform
     * @return
     * @throws Exception
     */
    public String getAppDau (String country, String appId, String date, String platform) throws Exception;

    /**
     * 查询各个数据源的相关数据
     * @param date
     * @param type
     * @return
     * @throws Exception
     */
    public List<Map<String, Object>> findSourcesData (String date, String type) throws Exception;

    /**
     * 获取各种ID统计数据
     * @param date
     * @return
     * @throws Exception
     */
    public List<Map<String, Object>> findIdsData(String date) throws Exception;
}
