package mobvista.prd.datasource.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import java.io.*;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/3/27 0027.
 */
public class ReadDspAppXls {
    public static void main(String[] args) throws IOException {
        List<String> list = Lists.newArrayList();
        Map<String,Map<String,String>> map = Maps.newHashMap();

        BufferedInputStream binput = new BufferedInputStream(new FileInputStream(new File("./dspApp.xls")));
        //创建xls读取对象
        HSSFWorkbook wb = new HSSFWorkbook(binput);
        for (int z = 0; z < 24; z++) {
            HSSFSheet sheet = wb.getSheetAt(z);
            //循环读取行
            Map<String,String> pakMap = Maps.newHashMap();
            String country = "";
            for (int i = sheet.getFirstRowNum() + 1, size = sheet.getLastRowNum(); i <= size; i++) {
                HSSFRow row = sheet.getRow(i);
                //循环读列

                String appName = "";
                HSSFCell packageName= null;
                String content = "";
                String platform = "";

                if (row != null) {
                    for (int j = row.getFirstCellNum(), k = row.getLastCellNum(); j < k; j++) {
                        if (j == 0) {
                            country = row.getCell(j).toString().trim();
                        }
                        if (j == 1) {
                            appName = row.getCell(j).toString().trim();
                        } else if (j == 2) {
                            packageName = row.getCell(j);
                            if (packageName != null) {
                                packageName.setCellType(HSSFCell.CELL_TYPE_STRING);
                                content = packageName.getStringCellValue();//此时content的数值为
                            }

                        } else if (j == 3) {
                            if (row.getCell(j) != null) {
                                platform = row.getCell(j).toString().trim();
                            }
                        }
                    }
                    if (!pakMap.containsKey(content)) {
                        pakMap.put(content, appName+"\t"+platform);
                    }
                }
            }
            map.put(country,pakMap);
        }
        for (Map.Entry<String, Map<String,String>> country : map.entrySet()) {
            for (Map.Entry<String,String> app : country.getValue().entrySet()) {
                StringBuilder line = new StringBuilder();
                line.append(country.getKey());
                line.append("\t");
                line.append(app.getValue());
                line.append("\t");
                line.append(app.getKey());
                WriteFile("./dspApp.txt", line.toString());
                WriteFile("./dspApp.txt", "\n");
            }
        }
    }

    public static void WriteFile(String path, String content) throws IOException {
        FileWriter fw = new FileWriter(path, true);
        fw.write(content);
        fw.close();//关闭文件
    }
}
