package mobvista.prd.datasource.table;

import com.google.common.collect.Lists;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import java.io.*;
import java.util.List;

/**
 * Created by liushuai on 2017/3/13 0013.
 */
public class ReadMAppXls {
    public static void main(String[] args) throws IOException {
        List<String> list = Lists.newArrayList();
        BufferedInputStream binput = new BufferedInputStream(new FileInputStream(new File("./app.xls")));
        //创建xls读取对象
        HSSFWorkbook wb = new HSSFWorkbook(binput);
        for (int z = 0; z < 25; z++) {
            HSSFSheet sheet = wb.getSheetAt(z);
            //循环读取行
            for (int i = sheet.getFirstRowNum() + 1, size = sheet.getLastRowNum(); i <= size; i++) {
                HSSFRow row = sheet.getRow(i);
                //循环读列
                StringBuilder app = new StringBuilder();
                for (int j = row.getFirstCellNum(), k = row.getLastCellNum(); j < k; j++) {
                    if (j == 1) {  //platform
                        app.append(row.getCell(j).toString().trim());
                    }
                    if (j == 3) { //app_name
                        app.append("\t");
                        app.append(row.getCell(j).toString().trim());
                    } else if (j == 4) {  //app_id
                        app.append("\t");
                        app.append(row.getCell(j).toString().trim());
                    } else if (j == 5) {   //impression
                        app.append("\t");
                        app.append(row.getCell(j).toString().trim());
                    }
                }
                list.add(app.toString());
            }
        }
        for (String line : list) {
            WriteFile("./app.txt", line);
            WriteFile("./app.txt", "\n");
        }
    }

    public static void WriteFile(String path, String content) throws IOException {
        FileWriter fw = new FileWriter(path, true);
        fw.write(content);
        fw.close();//关闭文件
    }
}
