package mobvista.prd.datasource.udf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mobvista.prd.datasource.util.GsonUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;

import java.util.ArrayList;
import java.util.List;

public class ParseJson extends UDF {

    public List<Text> evaluate(String jsonArrayStr, String key) {
        if (StringUtils.isBlank(jsonArrayStr) || StringUtils.isBlank(jsonArrayStr)) {
            return null;
        }
        List<Text> textList = new ArrayList<Text>();
        if (!jsonArrayStr.trim().startsWith("[")) {
            textList.add(new Text(jsonArrayStr));
        } else {
            JsonArray array = GsonUtil.String2JsonArray(jsonArrayStr);
            JsonObject json = null;
            for (JsonElement element : array) {
                json = element.getAsJsonObject();
                JsonElement e = json.get(key);
                if (e != null && !e.isJsonNull()) {
                    textList.add(new Text(e.getAsString()));
                } else {
                    textList.add(new Text(""));
                }
            }
        }
        return textList;
    }

    public List<Text> evaluate(String jsonArrayStr, String key, String regex) {
        if (StringUtils.isBlank(jsonArrayStr) || StringUtils.isBlank(jsonArrayStr)) {
            return null;
        }
        List<Text> textList = new ArrayList<Text>();
        if (!jsonArrayStr.trim().startsWith("[")) {
            textList.add(new Text(jsonArrayStr));
        } else {
            JsonArray array = GsonUtil.String2JsonArray(jsonArrayStr);
            JsonObject json = null;
            for (JsonElement element : array) {
                json = element.getAsJsonObject();
                JsonElement e = json.get(key);
                if (e != null && !e.isJsonNull() && e.getAsString().matches(regex)) {
                    textList.add(new Text(e.getAsString()));
                }
            }
        }
        return textList;
    }
}
