package mobvista.dmp.datasource.adn

import mobvista.dmp.common.MobvistaConstant
import org.apache.commons.lang.StringUtils

/**
 * @package: mobvista.dmp.datasource.adn
 * @author: wangjf
 * @date: 2020/8/3
 * @time: 1:58 下午
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
object AdnConstant {

  val adn_request_etl_sql =
    """
      |SELECT date, time, created, app_id, platform, os_version, sdk_version, device_model, screen_size, country_code, language, strategy, ip, imei,
      |  mac, dev_id android_id, gaid, idfa, device_brand, ext_packagename, getDevId(ext_sysid) sysid, ext_oaid oaid, getDevId(cdn_ab) idfv, re
      |  FROM dwh.ods_adn_trackingnew_request WHERE CONCAT(yyyy,mm,dd,hh) = '@datetime'
      |  AND check_devId(platform, idfa, cdn_ab, imei, dev_id, gaid, ext_sysid, ext_oaid)
      |""".stripMargin

  val adn_install_etl_sql =
    """
      |SELECT campaign_id, platform, os_version, sdk_version, device_model, scree_size, country_code,
      |  requestid, imei, mac, dev_id android_id, gaid, idfa, device_brand, ext_sysid, ext_oaid, cdn_ab, re
      |  FROM dwh.ods_adn_trackingnew_install WHERE CONCAT(yyyy,mm,dd) = '@datetime'
      |""".stripMargin

  val adn_request_other_etl_sql =
    """
      |
      |""".stripMargin

  //  校验设备ID
  def check_devId(platform: String, idfa: String, cdn_ab: String, imei: String, android_id: String, gaid: String, ext_sysid: String, ext_oaid: String): Boolean = {
    var flag = false
    val idfv = getDevId(cdn_ab)
    val sysid = getDevId(ext_sysid)
    if (StringUtils.isNotBlank(platform) && "ios".equals(platform)) {
      if ((StringUtils.isNotBlank(idfa) && idfa.matches(MobvistaConstant.didPtn) && !idfa.matches(MobvistaConstant.allZero))
        || (StringUtils.isNotBlank(idfv) && idfv.matches(MobvistaConstant.didPtn) && !idfv.matches(MobvistaConstant.allZero))) {
        flag = true
      }
    } else {
      if ((StringUtils.isNotBlank(gaid) && gaid.matches(MobvistaConstant.didPtn) && !gaid.matches(MobvistaConstant.allZero))
        || (StringUtils.isNotBlank(imei) && imei.matches(MobvistaConstant.imeiPtn) && !imei.matches(MobvistaConstant.imeiPtnAll))
        || (StringUtils.isNotBlank(android_id) && android_id.matches(MobvistaConstant.andriodIdPtn) && !android_id.matches(MobvistaConstant.andriodIdAll))) {
        flag = true
      }
    }
    if (StringUtils.isNotBlank(sysid) && sysid.matches(MobvistaConstant.didPtn) && !MobvistaConstant.allZero.matches(sysid)) {
      flag = true
    }
    if (StringUtils.isNotBlank(ext_oaid) && ext_oaid.matches(MobvistaConstant.didPtn) && !ext_oaid.matches(MobvistaConstant.allZero)) {
      flag = true
    }
    flag
  }

  //  解析 sysId / idfv
  def getDevId(devId: String): String = {
    var dev_id = ""
    if (StringUtils.isNotBlank(devId) && !",".equals(devId)) {
      val ids = devId.split(",", -1)
      if (StringUtils.isNotBlank(ids(0)) && ids(0).matches(MobvistaConstant.didPtn) && !ids(0).matches(MobvistaConstant.allZero)) {
        dev_id = ids(0)
      } else if (ids.length == 2 && !ids(1).matches(MobvistaConstant.didPtn) && !ids(1).matches(MobvistaConstant.allZero)) {
        dev_id = ids(1)
      }
    }
    dev_id
  }

  //  解析 ruid
  def getRuid(ext_algo: String): String = {
    var ruid = if (StringUtils.isNotBlank(ext_algo) && ext_algo.split(",", -1).length >= 42) {
      ext_algo.split(",", -1)(41).split("\004", -1)(0)
    } else {
      ""
    }
    if (StringUtils.isBlank(ruid) || ruid.length < 16) {
      ruid = ""
    }
    ruid
  }
}
