package mobvista.dmp.datasource.adn_request_other

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily}
import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * @package: mobvista.dmp.datasource.adn
  * @author: wangjf
  * @date: 2019/3/19
  * @time: 下午1:51
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class AdnRequestOtherTagDaily extends MatchInterestTagDaily with Serializable {
  override def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val sql = Constant.adn_request_other_sql.replace("@dt", date)
    spark.sql(sql)
  }
}

object AdnRequestOtherTagDaily {
  def main(args: Array[String]): Unit = {
    new AdnRequestOtherTagDaily().run(args)
  }
}