package mobvista.dmp.datasource.app_info_tag

import mobvista.dmp.common.CommonSparkJob
import org.apache.commons.cli.{BasicParser, Options}
import org.apache.spark.sql.types.{StringType, StructField, StructType}
import org.apache.spark.sql.{Row, SaveMode, SparkSession}

class Etl_app_info_ios_v2 extends CommonSparkJob with Serializable {

  def commandOptions(): Options = {
    val options = new Options()
    options.addOption("date", true, "date")
    options.addOption("output", true, "output")
    options
  }

  override protected def run(args: Array[String]): Int = {
    val parser = new BasicParser()
    val options = commandOptions()
    val commandLine = parser.parse(options, args)
    val date = commandLine.getOptionValue("date")
    val output = commandLine.getOptionValue("output")
    val spark = SparkSession
      .builder()
      .appName("Etl_app_info_ios_v2")
      .config("spark.rdd.compress", "true")
      .config("spark.shuffle.compress", "true")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.io.compression.codec", "lz4")
      .config("spark.io.compression.lz4.blockSize", "64k")
      .config("spark.sql.autoBroadcastJoinThreshold", "209715200")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()

    try {
      val jobContext = spark.sqlContext
      val sql =
        s"""
           |select * from dwh.dim_app_info_ios where concat(year,month,day)='${date}'
        """.stripMargin
      val ios_rdd = spark.sql(sql).rdd.map(p => {
        Row(
          p(0),
          p(1),
          p(2),
          p(3),
          p(4),
          p(5),
          p(6),
          p(7),
          p(8),
          p(9),
          p(10),
          p(11),
          p(12),
          p(13),
          p(14),
          p(15),
          p(16),
          p(17),
          p(18)
        )
      })
      val ios_schema = StructType(Array(
        StructField("package_name", StringType, true),
        StructField("app_name", StringType, true),
        StructField("file_size_bytes", StringType, true),
        StructField("support_language", StringType, true),
        StructField("bundle_id", StringType, true),
        StructField("release_date", StringType, true),
        StructField("primary_category", StringType, true),
        StructField("primary_category_id", StringType, true),
        StructField("category_list", StringType, true),
        StructField("category_id_list", StringType, true),
        StructField("user_rating_count", StringType, true),
        StructField("track_view_url", StringType, true),
        StructField("update_time", StringType, true),
        StructField("artist_id", StringType, true),
        StructField("artist_name", StringType, true),
        StructField("seller_name", StringType, true),
        StructField("is_game_center_enabled", StringType, true),
        StructField("content_advisory_rating", StringType, true),
        StructField("advisories", StringType, true)
      ))
      val result = spark.createDataFrame(ios_rdd, ios_schema)
      result.write.format("orc").mode(SaveMode.Overwrite).save(output)

    } finally {
      if (spark != null) {
        spark.stop()
      }
    }
    0
  }
}

object Etl_app_info_ios_v2 {
  def main(args: Array[String]): Unit = {
    new Etl_app_info_ios_v2().run(args)
  }
}